/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.settings.user;

import com.ibm.hwmca.fw.util.LocalizableText;

public class StatusBackgroundConstants {
    public static final int MAX_COLORS = 16;
    public static final String COLOR_NAME_BLACK = "black";
    public static final String COLOR_NAME_BLUE = "blue";
    public static final String COLOR_NAME_BROWN = "brown";
    public static final String COLOR_NAME_CYAN = "cyan";
    public static final String COLOR_NAME_DARKBLUE = "darkblue";
    public static final String COLOR_NAME_DARKCYAN = "darkcyan";
    public static final String COLOR_NAME_DARKGRAY = "darkgray";
    public static final String COLOR_NAME_DARKGREEN = "darkgreen";
    public static final String COLOR_NAME_DARKMAGENTA = "darkmagenta";
    public static final String COLOR_NAME_DARKRED = "darkred";
    public static final String COLOR_NAME_GRAY = "gray";
    public static final String COLOR_NAME_GREEN = "green";
    public static final String COLOR_NAME_MAGENTA = "magenta";
    public static final String COLOR_NAME_RED = "red";
    public static final String COLOR_NAME_WHITE = "white";
    public static final String COLOR_NAME_YELLOW = "yellow";
    public static final String IMAGE_TYPE = ".gif";
    public static final String ANIMATED_IMAGE_TYPE = "animated.gif";
    public static final String COLOR_IMAGE_NAME_BLACK = "/res/com/ibm/hwmca/fw/images/black.gif";
    public static final String COLOR_IMAGE_NAME_BLUE = "/res/com/ibm/hwmca/fw/images/blue.gif";
    public static final String COLOR_IMAGE_NAME_BROWN = "/res/com/ibm/hwmca/fw/images/brown.gif";
    public static final String COLOR_IMAGE_NAME_CYAN = "/res/com/ibm/hwmca/fw/images/cyan.gif";
    public static final String COLOR_IMAGE_NAME_DARKBLUE = "/res/com/ibm/hwmca/fw/images/darkblue.gif";
    public static final String COLOR_IMAGE_NAME_DARKCYAN = "/res/com/ibm/hwmca/fw/images/darkcyan.gif";
    public static final String COLOR_IMAGE_NAME_DARKGRAY = "/res/com/ibm/hwmca/fw/images/darkgray.gif";
    public static final String COLOR_IMAGE_NAME_DARKGREEN = "/res/com/ibm/hwmca/fw/images/darkgreen.gif";
    public static final String COLOR_IMAGE_NAME_DARKMAGENTA = "/res/com/ibm/hwmca/fw/images/darkmagenta.gif";
    public static final String COLOR_IMAGE_NAME_DARKRED = "/res/com/ibm/hwmca/fw/images/darkred.gif";
    public static final String COLOR_IMAGE_NAME_GRAY = "/res/com/ibm/hwmca/fw/images/gray.gif";
    public static final String COLOR_IMAGE_NAME_GREEN = "/res/com/ibm/hwmca/fw/images/green.gif";
    public static final String COLOR_IMAGE_NAME_MAGENTA = "/res/com/ibm/hwmca/fw/images/magenta.gif";
    public static final String COLOR_IMAGE_NAME_RED = "/res/com/ibm/hwmca/fw/images/red.gif";
    public static final String COLOR_IMAGE_NAME_WHITE = "/res/com/ibm/hwmca/fw/images/white.gif";
    public static final String COLOR_IMAGE_NAME_YELLOW = "/res/com/ibm/hwmca/fw/images/yellow.gif";
    public static final String COLOR_IMAGE_NAME_TRANSPARENT = "/res/com/ibm/hwmca/fw/images/transparent.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE1 = "/res/com/ibm/hwmca/fw/images/dense1.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE2 = "/res/com/ibm/hwmca/fw/images/dense2.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE3 = "/res/com/ibm/hwmca/fw/images/dense3.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE4 = "/res/com/ibm/hwmca/fw/images/dense4.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE5 = "/res/com/ibm/hwmca/fw/images/dense5.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE6 = "/res/com/ibm/hwmca/fw/images/dense6.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE7 = "/res/com/ibm/hwmca/fw/images/dense7.gif";
    public static final String PATTERN_IMAGE_NAME_DENSE8 = "/res/com/ibm/hwmca/fw/images/dense8.gif";
    public static final String PATTERN_IMAGE_NAME_DIAGONAL1 = "/res/com/ibm/hwmca/fw/images/diagonal1.gif";
    public static final String PATTERN_IMAGE_NAME_DIAGONAL2 = "/res/com/ibm/hwmca/fw/images/diagonal2.gif";
    public static final String PATTERN_IMAGE_NAME_DIAGONAL3 = "/res/com/ibm/hwmca/fw/images/diagonal3.gif";
    public static final String PATTERN_IMAGE_NAME_DIAGONAL4 = "/res/com/ibm/hwmca/fw/images/diagonal4.gif";
    public static final String PATTERN_IMAGE_NAME_HORIZONTAL = "/res/com/ibm/hwmca/fw/images/horizontal.gif";
    public static final String PATTERN_IMAGE_NAME_VERTICAL = "/res/com/ibm/hwmca/fw/images/vertical.gif";
    public static final String PATTERN_IMAGE_NAME_SOLIDBLACK = "/res/com/ibm/hwmca/fw/images/black.gif";
    public static final String PATTERN_IMAGE_NAME_SOLIDWHITE = "/res/com/ibm/hwmca/fw/images/white.gif";
    public static final int RGB_BLACK = 0;
    public static final int RGB_BLUE = 255;
    public static final int RGB_BROWN = 0xA52A2A;
    public static final int RGB_CYAN = 65535;
    public static final int RGB_DARKBLUE = 139;
    public static final int RGB_DARKCYAN = 35723;
    public static final int RGB_DARKGRAY = 0xA9A9A9;
    public static final int RGB_DARKGREEN = 25600;
    public static final int RGB_DARKMAGENTA = 0x8B008B;
    public static final int RGB_DARKRED = 0x8B0000;
    public static final int RGB_GRAY = 0x808080;
    public static final int RGB_GREEN = 32768;
    public static final int RGB_MAGENTA = 0xFF00FF;
    public static final int RGB_RED = 0xFF0000;
    public static final int RGB_WHITE = 0xFFFFFF;
    public static final int RGB_YELLOW = 0xFFFF00;
    private static int[] rgbValues;
    private static LocalizableText[] colorText;
    private static LocalizableText[] patternText;
    private static String[] colorImageNames;
    private static String[] patternImageNames;
    private static String[] colorNames;

    public static LocalizableText[] getColorText() {
        return colorText;
    }

    public static LocalizableText[] getPatternText() {
        return patternText;
    }

    public static String[] getColorImageFileNames() {
        return colorImageNames;
    }

    public static String getAnimatedForImageName(String imageName) {
        return imageName.replaceAll(IMAGE_TYPE, ANIMATED_IMAGE_TYPE);
    }

    public static String getTinyForImageName(String imageName) {
        int index = imageName.lastIndexOf("/");
        if (imageName.substring(index + 1, index + 5).equals("tiny")) {
            return imageName;
        }
        return imageName.substring(0, index + 1) + "tiny" + imageName.substring(index + 1);
    }

    public static String getColorImageFileNameAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > 15) {
            throw new IndexOutOfBoundsException("StatusBackgroundConstants.getColorImageNameAt() passed index of " + index);
        }
        return colorImageNames[index];
    }

    public static int getColorImageIndex(String imageName) {
        for (int i = 0; i < colorImageNames.length; ++i) {
            if (!colorImageNames[i].equals(imageName)) continue;
            return i;
        }
        return -1;
    }

    public static String[] getPatternImageFileNames() {
        return patternImageNames;
    }

    public static String getPatternImageFileNameAt(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > 15) {
            throw new IndexOutOfBoundsException("StatusBackgroundConstants.getPatternImageNameAt() passed index of " + index);
        }
        return patternImageNames[index];
    }

    public static int getPatternImageIndex(String imageName) {
        for (int i = 0; i < patternImageNames.length; ++i) {
            if (!patternImageNames[i].equals(imageName)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isValidColorImageName(String imageName) {
        return StatusBackgroundConstants.isValidImageName(imageName, colorImageNames);
    }

    public static boolean isValidPatternImageName(String imageName) {
        return StatusBackgroundConstants.isValidImageName(imageName, patternImageNames);
    }

    public static boolean isValidImageName(String imageName, String[] supportedImageNames) {
        for (int i = 0; i < supportedImageNames.length; ++i) {
            if (!supportedImageNames[i].equals(imageName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRgbValue(int rgb) {
        for (int i = 0; i < rgbValues.length; ++i) {
            if (rgbValues[i] != rgb) continue;
            return true;
        }
        return false;
    }

    public static int getRgbForColorImageName(String imageName) {
        for (int i = 0; i < colorImageNames.length; ++i) {
            if (!colorImageNames[i].equals(imageName)) continue;
            return rgbValues[i];
        }
        return 0;
    }

    public static int getRgbForColorName(String name) {
        for (int i = 0; i < colorNames.length; ++i) {
            if (!colorNames[i].equals(name)) continue;
            return rgbValues[i];
        }
        return 0;
    }

    static {
        colorText = new LocalizableText[]{new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.black.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.blue.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.brown.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.cyan.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.darkblue.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.darkcyan.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.darkgray.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.darkgreen.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.darkmagenta.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.darkred.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.gray.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.green.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.magenta.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.red.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.white.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.color.yellow.name")};
        patternText = new LocalizableText[]{new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense1.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense2.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense3.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense4.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense5.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense6.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense7.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.dense8.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.diagonal1.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.diagonal2.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.diagonal3.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.diagonal4.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.horz1.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.vert1.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.solidblack.name"), new LocalizableText("com/ibm/hwmca/base/res/text", "settings.user.pattern.solidwhite.name")};
        rgbValues = new int[]{0, 255, 0xA52A2A, 65535, 139, 35723, 0xA9A9A9, 25600, 0x8B008B, 0x8B0000, 0x808080, 32768, 0xFF00FF, 0xFF0000, 0xFFFFFF, 0xFFFF00};
        colorImageNames = new String[]{"/res/com/ibm/hwmca/fw/images/black.gif", COLOR_IMAGE_NAME_BLUE, COLOR_IMAGE_NAME_BROWN, COLOR_IMAGE_NAME_CYAN, COLOR_IMAGE_NAME_DARKBLUE, COLOR_IMAGE_NAME_DARKCYAN, COLOR_IMAGE_NAME_DARKGRAY, COLOR_IMAGE_NAME_DARKGREEN, COLOR_IMAGE_NAME_DARKMAGENTA, COLOR_IMAGE_NAME_DARKRED, COLOR_IMAGE_NAME_GRAY, COLOR_IMAGE_NAME_GREEN, COLOR_IMAGE_NAME_MAGENTA, COLOR_IMAGE_NAME_RED, "/res/com/ibm/hwmca/fw/images/white.gif", COLOR_IMAGE_NAME_YELLOW};
        patternImageNames = new String[]{PATTERN_IMAGE_NAME_DENSE1, PATTERN_IMAGE_NAME_DENSE2, PATTERN_IMAGE_NAME_DENSE3, PATTERN_IMAGE_NAME_DENSE4, PATTERN_IMAGE_NAME_DENSE5, PATTERN_IMAGE_NAME_DENSE6, PATTERN_IMAGE_NAME_DENSE7, PATTERN_IMAGE_NAME_DENSE8, PATTERN_IMAGE_NAME_DIAGONAL1, PATTERN_IMAGE_NAME_DIAGONAL2, PATTERN_IMAGE_NAME_DIAGONAL3, PATTERN_IMAGE_NAME_DIAGONAL4, PATTERN_IMAGE_NAME_HORIZONTAL, PATTERN_IMAGE_NAME_VERTICAL, "/res/com/ibm/hwmca/fw/images/black.gif", "/res/com/ibm/hwmca/fw/images/white.gif"};
        colorNames = new String[]{COLOR_NAME_BLACK, COLOR_NAME_BLUE, COLOR_NAME_BROWN, COLOR_NAME_CYAN, COLOR_NAME_DARKBLUE, COLOR_NAME_DARKCYAN, COLOR_NAME_DARKGRAY, COLOR_NAME_DARKGREEN, COLOR_NAME_DARKMAGENTA, COLOR_NAME_DARKRED, COLOR_NAME_GRAY, COLOR_NAME_GREEN, COLOR_NAME_MAGENTA, COLOR_NAME_RED, COLOR_NAME_WHITE, COLOR_NAME_YELLOW};
    }
}

